<?php 
/**
 * Absen_remaja Page Controller
 * @category  Controller
 */
class Absen_remajaController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "absen_remaja";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("id", 
			"desa", 
			"nama", 
			"kelompok", 
			"tahun_lahir", 
			"rombel", 
			"waktu", 
			"jenis_kelamin", 
			"zona");
		$pagination = $this->get_pagination(500); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				absen_remaja.id LIKE ? OR 
				absen_remaja.desa LIKE ? OR 
				absen_remaja.nama LIKE ? OR 
				absen_remaja.kelompok LIKE ? OR 
				absen_remaja.tahun_lahir LIKE ? OR 
				absen_remaja.rombel LIKE ? OR 
				absen_remaja.waktu LIKE ? OR 
				absen_remaja.jenis_kelamin LIKE ? OR 
				absen_remaja.zona LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "absen_remaja/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("kelompok", "ASC");
			$db->orderBy("waktu", "ASC");
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Penerobosan Muda-Mudi";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$view_name = (is_ajax() ? "absen_remaja/ajax-list.php" : "absen_remaja/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("id", 
			"desa", 
			"kelompok", 
			"nama", 
			"rombel", 
			"tahun_lahir", 
			"waktu", 
			"jenis_kelamin", 
			"zona");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("absen_remaja.id", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Absen Remaja";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("absen_remaja/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("desa","kelompok","nama","jenis_kelamin","rombel","waktu","zona");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'desa' => 'required',
				'kelompok' => 'required',
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'rombel' => 'required',
				'waktu' => 'required',
				'zona' => 'required',
			);
			$this->sanitize_array = array(
				'desa' => 'sanitize_string',
				'kelompok' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'rombel' => 'sanitize_string',
				'waktu' => 'sanitize_string',
				'zona' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Berhasil disimpan!", "success");
					return	$this->redirect("absen_remaja");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add Absen Remaja";
		$this->render_view("absen_remaja/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("id","nama","jenis_kelamin","rombel");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'rombel' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'rombel' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("absen_remaja.id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Berhasil diupdate!", "success");
					return $this->redirect("absen_remaja");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("absen_remaja");
					}
				}
			}
		}
		$db->where("absen_remaja.id", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Absen Remaja";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("absen_remaja/edit.php", $data);
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("absen_remaja.id", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Berhasil dihapus!", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("absen_remaja");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function absen($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("id", 
			"desa", 
			"kelompok", 
			"nama", 
			"rombel", 
			"tahun_lahir", 
			"waktu", 
			"jenis_kelamin", 
			"zona");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				absen_remaja.id LIKE ? OR 
				absen_remaja.desa LIKE ? OR 
				absen_remaja.kelompok LIKE ? OR 
				absen_remaja.nama LIKE ? OR 
				absen_remaja.rombel LIKE ? OR 
				absen_remaja.tahun_lahir LIKE ? OR 
				absen_remaja.waktu LIKE ? OR 
				absen_remaja.jenis_kelamin LIKE ? OR 
				absen_remaja.zona LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "absen_remaja/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("absen_remaja.id", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Absen Remaja";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$view_name = (is_ajax() ? "absen_remaja/ajax-absen.php" : "absen_remaja/absen.php");
		$this->render_view($view_name, $data);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add_absen($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("desa","kelompok","nama","jenis_kelamin","rombel","waktu","zona");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'desa' => 'required',
				'kelompok' => 'required',
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'rombel' => 'required',
				'waktu' => 'required',
				'zona' => 'required',
			);
			$this->sanitize_array = array(
				'desa' => 'sanitize_string',
				'kelompok' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'rombel' => 'sanitize_string',
				'waktu' => 'sanitize_string',
				'zona' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Berhasil disimpan!", "success");
					return	$this->redirect("absen_remaja/absen");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add Absen Remaja";
		$this->render_view("absen_remaja/add_absen.php");
	}
}
