<?php 
/**
 * Data_generus Page Controller
 * @category  Controller
 */
class Data_generusController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "data_generus";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("id", 
			"nama_lengkap", 
			"jenis_kelamin", 
			"tahun_lahir", 
			"desa", 
			"kelompok", 
			"kelas", 
			"rombel", 
			"author", 
			"keterangan");
		$pagination = $this->get_pagination(200); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				data_generus.id LIKE ? OR 
				data_generus.nama_lengkap LIKE ? OR 
				data_generus.jenis_kelamin LIKE ? OR 
				data_generus.tahun_lahir LIKE ? OR 
				data_generus.desa LIKE ? OR 
				data_generus.kelompok LIKE ? OR 
				data_generus.kelas LIKE ? OR 
				data_generus.rombel LIKE ? OR 
				data_generus.author LIKE ? OR 
				data_generus.keterangan LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "data_generus/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("nama_lengkap", "ASC");
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Data Generus";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$view_name = (is_ajax() ? "data_generus/ajax-list.php" : "data_generus/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("id", 
			"nama_lengkap", 
			"jenis_kelamin", 
			"tahun_lahir", 
			"desa", 
			"kelompok", 
			"kelas", 
			"rombel", 
			"author", 
			"keterangan");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("data_generus.id", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Data Generus";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("data_generus/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("nama_lengkap","jenis_kelamin","tahun_lahir","desa","kelompok","kelas","rombel","keterangan");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama_lengkap' => 'required',
				'jenis_kelamin' => 'required',
				'tahun_lahir' => 'required|numeric',
				'desa' => 'required',
				'kelompok' => 'required',
				'kelas' => 'required',
				'rombel' => 'required',
				'keterangan' => 'required',
			);
			$this->sanitize_array = array(
				'nama_lengkap' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'tahun_lahir' => 'sanitize_string',
				'desa' => 'sanitize_string',
				'kelompok' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'rombel' => 'sanitize_string',
				'keterangan' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Berhasil disimpan!", "success");
					return	$this->redirect("data_generus");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Tambah Data Generus";
		$this->render_view("data_generus/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("id","nama_lengkap","jenis_kelamin","tahun_lahir","desa","kelompok","kelas","rombel","keterangan");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama_lengkap' => 'required',
				'jenis_kelamin' => 'required',
				'tahun_lahir' => 'required|numeric',
				'desa' => 'required',
				'kelompok' => 'required',
				'kelas' => 'required',
				'rombel' => 'required',
				'keterangan' => 'required',
			);
			$this->sanitize_array = array(
				'nama_lengkap' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'tahun_lahir' => 'sanitize_string',
				'desa' => 'sanitize_string',
				'kelompok' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'rombel' => 'sanitize_string',
				'keterangan' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("data_generus.id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Berhasil diupdate!", "success");
					return $this->redirect("data_generus");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("data_generus");
					}
				}
			}
		}
		$db->where("data_generus.id", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Data Generus";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("data_generus/edit.php", $data);
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("data_generus.id", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Berhasil dihapus!", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("data_generus");
	}
}
