<?php 

/**
 * SharedController Controller
 * @category  Controller / Model
 */
class SharedController extends BaseController{
	
	/**
     * absen_remaja_desa_option_list Model Action
     * @return array
     */
	function absen_remaja_desa_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_desa AS value,nama_desa AS label FROM master_desa ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * absen_remaja_kelompok_option_list Model Action
     * @return array
     */
	function absen_remaja_kelompok_option_list($lookup_desa){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_kelompok AS value,nama_kelompok AS label FROM master_kelompok WHERE nama_desa= ? ORDER BY id ASC" ;
		$queryparams = array($lookup_desa);
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * absen_remaja_nama_option_list Model Action
     * @return array
     */
	function absen_remaja_nama_option_list($lookup_kelompok){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_lengkap AS value,nama_lengkap AS label FROM data_generus WHERE kelompok= ? ORDER BY nama_lengkap ASC" ;
		$queryparams = array($lookup_kelompok);
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * absen_remaja_jenis_kelamin_option_list Model Action
     * @return array
     */
	function absen_remaja_jenis_kelamin_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT jenis_kelamin AS value,jenis_kelamin AS label FROM master_jenis_kelamin ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * absen_remaja_rombel_option_list Model Action
     * @return array
     */
	function absen_remaja_rombel_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_sambung AS value,nama_sambung AS label FROM master_sambung ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generus_jenis_kelamin_option_list Model Action
     * @return array
     */
	function data_generus_jenis_kelamin_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT jenis_kelamin AS value,jenis_kelamin AS label FROM master_jenis_kelamin ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generus_desa_option_list Model Action
     * @return array
     */
	function data_generus_desa_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_desa AS value,nama_desa AS label FROM master_desa ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generus_kelompok_option_list Model Action
     * @return array
     */
	function data_generus_kelompok_option_list($lookup_desa){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_kelompok AS value,nama_kelompok AS label FROM master_kelompok WHERE nama_desa= ? ORDER BY id ASC" ;
		$queryparams = array($lookup_desa);
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generus_kelas_option_list Model Action
     * @return array
     */
	function data_generus_kelas_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_kelas AS value,nama_kelas AS label FROM master_kelas ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generus_rombel_option_list Model Action
     * @return array
     */
	function data_generus_rombel_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_sambung AS value,nama_sambung AS label FROM master_sambung ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generuskelompok_list Model Action
     * @return array
     */
	function data_generuskelompok_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT kelompok , kelompok ,   COUNT(*) AS num FROM data_generus where desa='Solok' or desa='Lembah Segar' GROUP BY kelompok ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * data_generuskelompok_list_2 Model Action
     * @return array
     */
	function data_generuskelompok_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT kelompok , kelompok ,   COUNT(*) AS num FROM data_generus where desa='Dharmasraya Utara' or desa='Dharmasraya Selatan' GROUP BY kelompok ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * getcount_lakilaki Model Action
     * @return Value
     */
	function getcount_lakilaki(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where jenis_kelamin='Laki-Laki' and zona='Zona 1'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_perempuan Model Action
     * @return Value
     */
	function getcount_perempuan(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where jenis_kelamin='Perempuan' and zona='Zona 1'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_jumlah Model Action
     * @return Value
     */
	function getcount_jumlah(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where zona='Zona 1'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_lakilaki_2 Model Action
     * @return Value
     */
	function getcount_lakilaki_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where jenis_kelamin='Laki-Laki' and zona='Zona 2'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_perempuan_2 Model Action
     * @return Value
     */
	function getcount_perempuan_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where jenis_kelamin='Perempuan' and zona='Zona 2'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_jumlah_2 Model Action
     * @return Value
     */
	function getcount_jumlah_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM absen_remaja where zona='Zona 2'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

}
