<?php 

/**
 * SharedController Controller
 * @category  Controller / Model
 */
class SharedController extends BaseController{
	
	/**
     * master_data_jenis_kelamin_option_list Model Action
     * @return array
     */
	function master_data_jenis_kelamin_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT jenis_kelamin AS value,jenis_kelamin AS label FROM master_jenis_kelamin ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_desa_option_list Model Action
     * @return array
     */
	function master_data_desa_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_desa AS value,nama_desa AS label FROM master_desa ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_kelompok_option_list Model Action
     * @return array
     */
	function master_data_kelompok_option_list($lookup_desa){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_kelompok AS value,nama_kelompok AS label FROM master_kelompok WHERE nama_desa= ? ORDER BY id ASC" ;
		$queryparams = array($lookup_desa);
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_status_option_list Model Action
     * @return array
     */
	function master_data_status_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT singkatan AS value,dapukan AS label FROM master_status ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_asrama_1_option_list Model Action
     * @return array
     */
	function master_data_asrama_1_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT asrama AS value,asrama AS label FROM master_asrama ORDER BY asrama DESC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_asrama_2_option_list Model Action
     * @return array
     */
	function master_data_asrama_2_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT asrama AS value,asrama AS label FROM master_asrama ORDER BY asrama DESC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_asrama_3_option_list Model Action
     * @return array
     */
	function master_data_asrama_3_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT asrama AS value,asrama AS label FROM master_asrama ORDER BY asrama DESC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * master_data_asrama_4_option_list Model Action
     * @return array
     */
	function master_data_asrama_4_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT asrama AS value,asrama AS label FROM master_asrama ORDER BY asrama DESC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * user_nama_value_exist Model Action
     * @return array
     */
	function user_nama_value_exist($val){
		$db = $this->GetModel();
		$db->where("nama", $val);
		$exist = $db->has("user");
		return $exist;
	}

	/**
     * user_desa_option_list Model Action
     * @return array
     */
	function user_desa_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_desa AS value,nama_desa AS label FROM master_desa ORDER BY id ASC";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * user_kelompok_option_list Model Action
     * @return array
     */
	function user_kelompok_option_list($lookup_desa){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT nama_kelompok AS value,nama_kelompok AS label FROM master_kelompok WHERE nama_desa= ? ORDER BY id ASC" ;
		$queryparams = array($lookup_desa);
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * user_email_value_exist Model Action
     * @return array
     */
	function user_email_value_exist($val){
		$db = $this->GetModel();
		$db->where("email", $val);
		$exist = $db->has("user");
		return $exist;
	}

	/**
     * getcount_solok Model Action
     * @return Value
     */
	function getcount_solok(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where desa='Solok'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_lembahsegar Model Action
     * @return Value
     */
	function getcount_lembahsegar(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where desa='Lembah Segar'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_dharmasrayautara Model Action
     * @return Value
     */
	function getcount_dharmasrayautara(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where desa='Dharmasraya Utara'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_dharmasrayaselatan Model Action
     * @return Value
     */
	function getcount_dharmasrayaselatan(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where desa='Dharmasraya selatan'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_harike1 Model Action
     * @return Value
     */
	function getcount_harike1(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where asrama_1='Ya'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_harike2 Model Action
     * @return Value
     */
	function getcount_harike2(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where asrama_2='Ya'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_harike3 Model Action
     * @return Value
     */
	function getcount_harike3(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where asrama_3='Ya'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_harike4 Model Action
     * @return Value
     */
	function getcount_harike4(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM master_data where asrama_4='Ya'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

}
